/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class VlanCreate
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275.GeneralResources");
    public static final int RASID = 19;
    public static final int RASSUB = 7;
    DestinationPropBook myBook;
    JdmBrowser browser;
    GenModel deviceModel;
    GenModel staticVlanModel;
    NavigationContext myContext;
    MessageBox messageToUser;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.put("newVlanName", " ");
        hashtable.put("newPortRegistration", new Integer(0));
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        Hashtable hashtable = null;
        String string = null;
        String string2 = null;
        Integer n = null;
        Vector vector = null;
        String string3 = "proceed";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string3);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string3, "Can't get browser- can't proceed with create");
            }
            bl = false;
        }
        if (this.deviceModel == null) {
            this.deviceModel = (GenModel)this.browser.getModel();
        }
        if (this.staticVlanModel == null) {
            try {
                this.staticVlanModel = (GenModel)this.deviceModel.getComponent("StaticVlan");
            }
            catch (Exception exception) {
                bl = false;
                string2 = new String("WZ_getError");
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string3, "Can't get staticVlan Model");
                }
                RAS.logError(19, 7, this, string3, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"staticVlan", (Object)"deviceModel");
            }
        }
        if (bl) {
            hashtable = jDMWizardInfo.getItems();
            genModel = jDMWizardInfo.getModel();
            try {
                string = (String)hashtable.get("newVlanName");
                n = (Integer)hashtable.get("newVlanId");
                vector = (Vector)hashtable.get("newPortRegistration");
                if (n <= 0) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string3, "invalid Vlan Num");
                    }
                    string2 = new String("WZ_invalidVlan");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string3, "unexpected/missing user data- can't create row");
                }
                RAS.logException(19, 7, this, string3, exception);
                string2 = new String("WZ_missingInfo");
                bl = false;
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.Vlan", n);
            try {
                modelInfo = genModel.getInfo("Panel", "default", modelInfo);
                if (modelInfo.get("Panel.VlanStatus") instanceof Integer) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string3, "Vlan already exists");
                    }
                    string2 = new String("VC_already exists");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string3, "unexcepted bypassable exception");
                }
                RAS.logException(19, 7, this, string3, exception);
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.Vlan", n);
            modelInfo.add("Panel.VlanStatus", new Integer(1));
            if (string.trim().length() != 0) {
                modelInfo.add("Panel.VlanNameString", (Serializable)((Object)string));
            }
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSnmpResponse(modelInfo);
                if (!bl) {
                    Serializable serializable = modelInfo.get("Panel.VlanStatus");
                    if (serializable instanceof SpecialValue) {
                        hashtable.put("newVlanId", serializable);
                    }
                    if ((serializable = modelInfo.get("Panel.VlanName.String")) instanceof SpecialValue) {
                        hashtable.put("newVlanName", serializable);
                    }
                    string2 = new String("WZ_badSet");
                }
            }
            catch (Exception exception) {
                bl = false;
                string2 = new String("WZ_badSet");
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string3, "Exception setting unicast Create data");
                }
                RAS.logException(19, 7, this, string3, exception);
            }
        }
        if (bl) {
            int n2 = 0;
            while (n2 < vector.size()) {
                Integer n3 = (Integer)vector.elementAt(n2);
                if (n3 != 3) {
                    modelInfo = new ModelInfo();
                    modelInfo.add("Index.StaticVlan", n);
                    modelInfo.add("Index.Port", new Integer(n2 + 1));
                    modelInfo.add("Panel.StaticVlanRegisterAttribute", n3);
                    try {
                        modelInfo = this.staticVlanModel.setInfo("Panel", modelInfo);
                        if (modelInfo.get("Panel.StaticVlanRegisterAttribute") instanceof SpecialValue) {
                            bl = false;
                            string2 = new String("VC_badPortSet");
                            if (RAS.isEnabled(19, 7)) {
                                RAS.trace(19, 7, this, string3, "Failed Port reg. port = " + (n2 + 1));
                            }
                        }
                    }
                    catch (Exception exception) {
                        bl = false;
                        string2 = new String("VC_badPortSet");
                        if (RAS.isEnabled(19, 7)) {
                            RAS.trace(19, 7, this, string3, "Execption ->Failed Port reg. port = " + (n2 + 1));
                        }
                        RAS.logException(19, 7, this, string3, exception);
                    }
                }
                ++n2;
            }
        }
        if (!bl && this.browser != null) {
            this.browser.displayMsg(VlanCreate.getNLSString(string2));
            this.messageToUser = new MessageBox(this.browser.getFrame(), VlanCreate.getNLSString("VC_error"), VlanCreate.getNLSString(string2), true);
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string3);
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        String string = "checkSnmpResponse";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string);
        }
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Error in snmp set. Variable is " + string2 + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
        return bl;
    }
}

